
import React from "react";
import { useState } from "react";
import axios from "axios";
import "../styles/login.css";

export default function LoginPage({ onOTPSent }) {
  const [nationalId, setNationalId] = useState("");
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState("");

  const handleSubmit = async (e) => {
    e.preventDefault();
    setError("");
    setLoading(true);
    try {
      await axios.post("http://localhost:5000/api/request-otp", { nationalId });
      onOTPSent(nationalId); // move to OTP screen
    } catch (err) {
      setError(err.response?.data?.message || "Something went wrong");
    }
    setLoading(false);
  };

  return (
    <div
      className="login-page"
      style={{ backgroundImage: "url('/login-bg.jpg')" }}
    >
      <div className="login-box">
        <img src="/MIPLOGO.png" alt="Misr Italia Properties" />
        <p className="subtitle">Welcome Back</p>

        <form onSubmit={handleSubmit} className="login-form">
          <label>ID Number / Passport Number</label>
          <input
            type="text"
            value={nationalId}
            onChange={(e) => setNationalId(e.target.value)}
            placeholder="Enter your ID number"
            required
          />
          {error && <p className="error-text">{error}</p>}
          <button type="submit" disabled={loading} className="login-button">
            {loading ? "Sending..." : "Login"}
          </button>
        </form>

        <p className="login-footer">
          Don’t have an Email? <span>Call 16519</span>
        </p>
      </div>
    </div>
  );
}
